//
//  MCTableColumnHelper.h
//  MCApplication
//
//  Created by Ali Lalani on 9/1/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCTableColumnHelperProtocol.h"
#import "MCDisplayStateProtocol.h"

@protocol MCTableColumnHelperProtocol,MCDisplayState;

@interface MCTableColumnHelper : NSObject <MCDisplayState> {
	NSTableView <MCTableColumnHelperProtocol>*tableView; // could be a NSTableView or an NSOutlineView(or anything else that adheres to the protocol)
	NSArrayController *arrayController;
	
	NSMutableDictionary *displayState;  // contains "ColumnOrder", "SortOrder" and "Columns"
	id                   displayStateDelegate;

	BOOL shouldSuspendSortOrderDisplayStateWrites; // certain things force a change in the sort ordering when we're not done setting up
	BOOL shouldSuspendColumnOrderDisplayStateWrites; 

	NSString *identifier;

	id document;

	// This is the fellow who we notify when we've changed the sort descriptors
	id tableSortDelegate;
}

#pragma mark ConfigurationAndSetup
- (void)configureWithIdentifier:(NSString *)ident;

- (void)configureColumn:(NSTableColumn *)col fromDictionary:(NSDictionary *)dict;
- (void)writeColumn:(NSTableColumn *)col toDictionary:(NSMutableDictionary *)dict;

- (void)setupCornerButton;

- (void)sizeToFit;

- (void)bindToArrayController:(NSArrayController *)anArrayController;

- (void)removeColumn:(NSTableColumn *)col;
- (void)addColumn:(NSTableColumn *)col;
- (void)addColumn:(NSTableColumn *)col atIndex:(unsigned)anIndex;
- (void)moveColumn:(NSTableColumn *)col toIndex:(unsigned)toIndex;

- (IBAction)activateColumnManager:(id)sender;

- (NSDictionary *)columnConfigurationForColumnWithIdentifier:(NSString *)ident;
- (SEL)sortSelectorForColumnWithIdentifier:(NSString *)anIdentifier;
- (NSDictionary *)columnConfigurationForDefaultSortColumn;


#pragma mark TableSorting
- (NSString *)sortKeyForColumnWithIdentifier:(NSString *)ident;
- (void)syncHeaderImageWithSortDescriptors;
- (void)syncHeaderImageWithSortDescriptorsForColumn:(NSTableColumn *)aCol;
- (void)syncTableHeaderTooltipWithSortDescriptors;
- (NSImage *)headerImageForAscending:(BOOL)isAscending number:(int)num tableColumn:(NSTableColumn *)col;
- (void)updateForNewSortDescriptors:(NSArray *)sorts;

#pragma mark Drawing
- (void)highlightSelectionInClipRect:(NSRect)rect;

#pragma mark Accessors

- (NSTableView <MCTableColumnHelperProtocol>*)tableView;
- (void)setTableView:(NSTableView <MCTableColumnHelperProtocol>*)anObj;

- (NSArray *)sortDescriptors;

- (NSArrayController *)arrayController;
- (void)setArrayController:(NSArrayController *)anArrayController;

- (BOOL)shouldSuspendSortOrderDisplayStateWrites;
- (void)setShouldSuspendSortOrderDisplayStateWrites:(BOOL)flag;

- (BOOL)shouldSuspendColumnOrderDisplayStateWrites;
- (void)setShouldSuspendColumnOrderDisplayStateWrites:(BOOL)flag;

- (NSString *)identifier;
- (void)setIdentifier:(NSString *)anIdentifier;

- (id)document;
- (void)setDocument:(id)aDocument;

- (id)tableSortDelegate;
- (void)setTableSortDelegate:(id)aTableSortDelegate;

#pragma mark DisplayStateReadWrite
- (void)readColumnConfigurationFromDisplayState;
- (void)writeColumnConfigurationToDisplayState;

- (void)readColumnOrderFromDisplayState;
- (void)writeColumnOrderToDisplayState;

- (void)readColumnSortOrderFromDisplayState;
- (void)writeColumnSortOrderToDisplayState;
@end

@interface NSObject (TableColumnHelperTableSortDelegate)
- (void)updateForNewSortDescriptors:(NSArray *)anArray;
@end

